/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateHollow.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"

//	 Creates a hollow on top face and return the newly created hollow.

HRESULT CreateHollow(ISet *pFace, double offsetDistance, CString hollowName, IHollow **pHollow)
{

	START_METHOD("CreateHollow")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IHollow *hollow = NULL;
	status = (GetCLASS(Hollow))->CreateHollow(pDesign, CAST(IObjectOrSet, pFace), offsetDistance, &hollow);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, hollow);
	status = operation->SetName(hollowName.AllocSysString());
	CHECK_RETURN_STATUS(status)

	*pHollow = hollow;

	END_METHOD("CreateHollow")
}
